'***********************
'433MHz Jaycar Receiver
'Picaxe 08M2
'i2c LCD 2 Line Display
'Phillip Webb 2012
'***********************
'b0 to b7 Rx data Bytes
symbol checksumIn = b8 'Rx data checksum
symbol checksum = b9 'Calculated checksum

symbol temp = w5 'b10 b11
symbol values =w6  'b12 b13 data to be displayed
symbol counter = w7 'b14 b15
symbol packetcounter = w8 'b16,b17
symbol messagenum =b18 'message number
symbol outbyte = b19 
symbol rs = b20 ' bit 0 of port expander 
symbol counter1 = b21 'second counter needed as lcd uses one
symbol nblcount = b22

symbol DeCode = 149 'Same as EnCode value for TX
symbol lcddata =1
symbol lcdinst =0
symbol Sertimeout = 5000 '  Serial input timeout


'*****************
'initilise I2C
i2cslave %01001110, i2cslow,i2cbyte ' %0-1-0-0-A2-A1-A0-0 is 8bit port expander. Address A0,A1,A2 all high
writei2c $00,(%00000000) '$00 is I/O set address, 0 sets GPIO to output, 1 sets to input

'******************
'Initialise LCD
rs = lcdinst
for counter = 0 to 5
	lookup counter, ($33,$32,$28,$0C,$01,$06),outbyte
	gosub lcdout
next counter
messagenum = 1
gosub display1stline ' display waiting message
pause 2000
messagenum =0
'******************
main:
gosub checkdata
gosub display1stline 'display message
gosub display2ndline 'display data
goto main
'************************
CheckData:
serin [Sertimeout,TimedOut], c.3 , N2400_4,("XYZ1"), b0,b1,b2,b3,b4,b5,b6,b7,checksumIn 
checksum = b0 + b1 + b2 + b3 + b4 + b5 + b6 + b7
if checksum = ChecksumIn then 'Station ID and checksum match - Data OK
	b4 = 0'b4 - decode receiving 10 bit value max 1023
	b3 = b3 - decode - 168 ' Use same values as per Tx
	b2 = b2 - decode - 15
	b1 = b1 - decode - 231
	b0 = b0 - decode -49
	packetcounter = packetcounter + 1
	Values = 0
	Values = b4 * 10000 'Tens of thousands
	Temp = b3 * 1000 'Thousands
	Values = Values + temp
	Temp = b2 *100 'Hundreds
	Values = Values + temp
	Temp = b1 * 10'Tens
	Values = Values + temp
	Values = Values + b0 'Units
	pulsout 4,1000 'Flash the LED
	messagenum = 0

end if
goto DataOK
TimedOut:
messagenum = 1

DataOK:
return
'************************
'Send to LCD
lcdout:
for nblcount = 1 to 2
	temp = outbyte & $F0 |2|rs 'high 4 bits + Clock Hi + RS
	writei2c $09, (temp) ' $09 address is the GPIO ports
	temp = temp & %11111101 'clock low ' don't change high order bits
	writei2c $09, (temp) ' $09 address is the GPIO ports
	pause 1
	outbyte = outbyte *16 'shift left 4 bits
next nblcount
return
'*******************
Display1stline:
	'display message
	rs = lcdinst
	outbyte = $80  ' first line
	gosub lcdout
	rs = lcddata
	for counter1 = 0 to 14
		select case messagenum
			case 0 ' Message 0
				lookup counter1 , ("Data Received: "), outbyte
			case 1 ' Message 1
			 	lookup counter1 , ("Waiting for Rx:"), outbyte
		end select
		gosub lcdout
	next counter1
return
Display2ndline:
	'display data
	rs = lcdinst  'second line
	outbyte = $C0
	gosub lcdout
	rs = lcddata
	' next display memory location
	for counter1 = 1 to 11   'require word variable for >255
		select case counter1
			case 1
				temp = values/10000  ' 10000's
			case 2
				temp = values/1000  '1000's
				temp = temp//10
			case 3
				temp = values/100  '100's
				temp = temp //10
			case 4
				temp = values/10   '10's
				temp = temp//10
			case 5
				temp = values//10  ' 1's
			case 6
				temp = 58- $30' "dec 58=:"			
			case 7
				temp = Packetcounter/10000  ' 10000's
			case 8
				temp = Packetcounter/1000  '1000's
				temp = temp//10
			case 9
				temp = packetcounter/100  '100's
				temp = temp //10
			case 10
				temp = Packetcounter/10   '10's
				temp = temp//10
			case 11
				temp = packetcounter//10  ' 1's
				
	end select
		outbyte = temp + $30
		gosub lcdout
	next counter1
return
'***************************